
************************************************************************
Poverty Clean 64-68
Program 4 out of 4 

4/29/10:  EDITED TO RUN ON JIM'S COMPUTER

************************************************************************;

%macro povclean6467(yr);
data poverty&yr;
   set cpsdata.cps&yr;

  RENAME _faminc=ftotval_final;
  RENAME official_povcut=fpovcut_final;
  RENAME pweight=msupwgt;

  frelu18_final=tot_kids;

run;
PROC SORT DATA=poverty&yr;
   BY famid;
RUN;
data poverty&yr;
   set poverty&yr;
   by famid;

* Create var for person number to be used in id var;
RETAIN counter 0; 
counter= counter+1;
IF FIRST.famid THEN DO; 
counter=1;
END;

id=famid*100+counter;

IF 2 LE wkswrk LE 7 THEN emp=1;
  ELSE emp=0; 

run;

PROC SORT DATA=poverty&yr;
   BY id;
RUN;

PROC SORT DATA=taxsim.taxs&yr;
   BY id;
RUN;
DATA poverty&yr;
MERGE poverty&yr(IN=in1) taxsim.taxs&yr(DROP=year RENAME=(fica=ts_fica));
BY id;
IF in1;


 ts_tottax=ftl+taxs+(ts_fica/2);

run;

PROC SORT DATA=poverty&yr;
   BY famid;
RUN;
proc means sum noprint data=poverty&yr;
   by famid;
   var ts_tottax emp;
   output out=tmp1(drop= _type_ _freq_) sum=fts_tottax tot_earnrs ;
run;

DATA poverty&yr;
MERGE poverty&yr(IN=in1) tmp1(KEEP=famid fts_tottax tot_earnrs);
BY famid;
IF in1;
run;

PROC SORT DATA=poverty&yr;
   BY hhid;
RUN;
proc means sum noprint data=poverty&yr;
   by hhid;
   var ts_tottax;
   output out=tmp3(drop= _type_ _freq_) sum=hts_tottax;
run;
proc means sum noprint data=poverty&yr;
   by hhid;
   WHERE (famtyp=1 AND famrel=0) OR (famtyp=3 AND famrel=0) OR famtyp IN(4,5);
   var ftotearn_final fpersons_final frelu18_final ftotval_final;
   output out=temp3(drop= _type_ _freq_) sum=htotearn hpersons hrelu18 htotval;
run;

DATA poverty&yr;
MERGE poverty&yr(IN=in1) tmp3(KEEP=hhid hts_tottax) temp3(KEEP=hhid htotearn hpersons hrelu18 htotval);
BY hhid;
IF in1;
run;

DATA temp;
SET poverty&yr;
* RESTRICT TO HEADS OF PRIMARY FAMIIES TO RETAIN FOR RELATED SUBFAMS, NOTE ALTHOUTH 
  SOME OF THESE VARS ARE ALREADY AT THE HEAD LEVEL, EDUCATION IS NOT;
IF (famtyp=1 AND famrel=0);

IF 2 LE wkswrk LE 7 THEN emp_head_prime=1;
  ELSE emp_head_prime=0; 

   IF _educ LE 11 THEN ed_head_prime=1;
      ELSE IF _educ=12 THEN ed_head_prime=2;
      ELSE IF 13 LE _educ LE 15 THEN ed_head_prime=3;
      ELSE IF _educ GE 16 THEN ed_head_prime=4;

IF hdage LE 64 AND tot_kids GT 0 AND marstat IN (0,4,5,6,7) THEN dem_grp_prime=1;
   ELSE IF hdage LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_prime=2;
   ELSE IF hdage LE 64 AND tot_kids=0 AND marstat IN (0,4,5,6,7) THEN dem_grp_prime=3;
   ELSE IF hdage LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_prime=4;
   ELSE IF hdage GE 65 THEN dem_grp_prime=5;

keep hhid emp_head_prime dem_grp_prime ed_head_prime;
run;

PROC SORT DATA=temp;
   BY hhid;
RUN;

data poverty&yr;
merge poverty&yr temp(keep=hhid emp_head_prime dem_grp_prime ed_head_prime);
by hhid;

RUN;

PROC SORT DATA=poverty&yr;
   BY famid;
RUN;

DATA temp2;
SET poverty&yr;
* RESTRICT TO HEADS OF PRIMARY FAMIIES TO RETAIN FOR RELATED SUBFAMS, NOTE ALTHOUTH 
  SOME OF THESE VARS ARE ALREADY AT THE HEAD LEVEL, EDUCATION IS NOT;
IF (famtyp=3 AND famrel=0) OR famtyp IN(4,5);

IF 2 LE wkswrk LE 7 THEN emp_head_nprime=1;
  ELSE emp_head_nprime=0; 

   IF _educ LE 11 THEN ed_head_nprime=1;
      ELSE IF _educ=12 THEN ed_head_nprime=2;
      ELSE IF 13 LE _educ LE 15 THEN ed_head_nprime=3;
      ELSE IF _educ GE 16 THEN ed_head_nprime=4;

IF hdage LE 64 AND tot_kids GT 0 AND marstat IN (0,4,5,6,7) THEN dem_grp_nprime=1;
   ELSE IF hdage LE 64 AND tot_kids GT 0 AND marstat IN (1,2,3) THEN dem_grp_nprime=2;
   ELSE IF hdage LE 64 AND tot_kids=0 AND marstat IN (0,4,5,6,7) THEN dem_grp_nprime=3;
   ELSE IF hdage LE 64 AND tot_kids=0 AND marstat IN (1,2,3) THEN dem_grp_nprime=4;
   ELSE IF hdage GE 65 THEN dem_grp_nprime=5;

run;

data poverty&yr;
merge poverty&yr temp2(keep=famid emp_head_nprime dem_grp_nprime ed_head_nprime);
by famid;

IF famtyp IN(1,2) THEN DO;
   emp_head=emp_head_prime;
   ed_head=ed_head_prime;
   dem_grp=dem_grp_prime;
END;
IF famtyp IN(3,4,5) THEN DO;
   emp_head=emp_head_nprime;
   ed_head=ed_head_nprime;
   dem_grp=dem_grp_nprime;
END;

hreg=region+1;

DROP povoeo dunern  region;

run;

proc means;
run;


%mend;

%povclean6467(1964);
%povclean6467(1965);
%povclean6467(1966);
%povclean6467(1967);

*Unlike future years we need not make an adjustment for total number of children in a family where the head of the family him/herself is 
under 18 years old.  In future years (68-72) our measure of tot_kids is all individuals in a family under 18 which would include a family 
head below the age of 18, however due to the nature of the data in 64-67 we use the fam18 variable as the measure of total kids in a family - 
we have discussed this and believe that fam18 does not take into account heads of families below 18, therefore no change need be made;
******************************************************************************
MACRO TO CREATE POVERTY CUTOFFS, POVERTY RATES, POPULATION ESTIMATES, 
AND ESTIMATES ON THE NUMBER OF POOR INDIVIDUALS FOR DIFFERENT SEGMENTS 
OF THE POPULATION
******************************************************************************; 
%macro poverty6467(yr);
data cpsdata.poverty&yr;
set poverty&yr;
*Poverty Thresholds 1964;
*Use 1964 Poverty Thresholds and deflate using CPI-U;
if &yr=1964 then do;
if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1650*0.987096774;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1482*0.987096774;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=2063*0.987096774;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2311*0.987096774;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1852*0.987096774;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2311*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2402*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2480*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3167*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3214*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3104*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3260*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3822*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3869*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3650*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3728*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4384*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4399*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4212*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4087*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4150*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5522*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5569*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5460*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5242*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5054*0.987096774;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=5008*0.987096774;


*Female non-farm;

else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1526*0.987096774;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1464*0.987096774;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1907*0.987096774;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2081*0.987096774;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1830*0.987096774;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2081*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2324*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2215*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2449*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3042*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3151*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3136*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3104*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3650*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3760*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3713*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3588*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4259*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4337*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4274*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4134*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4009*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5350*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5429*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5413*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5226*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5117*0.987096774;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=4867*0.987096774;


*Male farm;

else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1155*0.987096774;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1037*0.987096774;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1444*0.987096774;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1618*0.987096774;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1296*0.987096774;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1618*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1681*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1736*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1835*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2217*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2250*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2173*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2282*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2675*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2708*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2555*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2610*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=3069*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3079*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2948*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2861*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2905*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3865*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3898*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3822*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3669*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3538*0.987096774;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3506*0.987096774;


*Female farm;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1068*0.987096774;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1025*0.987096774;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1335*0.987096774;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1457*0.987096774;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1281*0.987096774;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1457*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1627*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1551*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1714*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2129*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2206*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2195*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2173*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2555*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2632*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2599*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2512*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=2981*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3036*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2992*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2894*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2806*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3745*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3800*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3789*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3658*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3582*0.987096774;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3407*0.987096774;

end;
*Poverty Thresholds 1965;
*Use Poverty 1964 Thresholds;
if &yr=1965 then do;

if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1650*1;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1482*1;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=2063*1;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2311*1;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1852*1;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2311*1;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2402*1;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2480*1;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2621*1;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3167*1;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3214*1;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3104*1;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3260*1;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3822*1;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3869*1;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3650*1;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3728*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4384*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4399*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4212*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4087*1;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4150*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5522*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5569*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5460*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5242*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5054*1;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=5008*1;


*Female non-farm;

else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1526*1;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1464*1;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1907*1;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2081*1;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1830*1;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2081*1;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2324*1;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2215*1;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2449*1;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3042*1;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3151*1;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3136*1;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3104*1;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3650*1;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3760*1;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3713*1;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3588*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4259*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4337*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4274*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4134*1;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4009*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5350*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5429*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5413*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5226*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5117*1;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=4867*1;


*Male farm;

else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1155*1;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1037*1;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1444*1;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1618*1;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1296*1;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1618*1;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1681*1;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1736*1;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1835*1;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2217*1;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2250*1;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2173*1;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2282*1;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2675*1;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2708*1;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2555*1;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2610*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=3069*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3079*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2948*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2861*1;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2905*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3865*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3898*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3822*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3669*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3538*1;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3506*1;

*Female farm;

else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1068*1;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1025*1;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1335*1;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1457*1;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1281*1;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1457*1;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1627*1;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1551*1;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1714*1;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2129*1;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2206*1;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2195*1;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2173*1;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2555*1;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2632*1;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2599*1;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2512*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=2981*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3036*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2992*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2894*1;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2806*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3745*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3800*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3789*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3658*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3582*1;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3407*1;
end;

*Poverty Thresholds 1966;
*Use 1964 Poverty Thresholds and inflate with CPI-U to 1965
Do not use 1966 Thresholds because some thresholds missing (Family size=2 Age head >65 Number of related children under 18=1);
if &yr=1966 then do;

if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1650*1.016129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1482*1.016129;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=2063*1.016129;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2311*1.016129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1852*1.016129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2311*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2402*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2480*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2621*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3167*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3214*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3104*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3260*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3822*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3869*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3650*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3728*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4384*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4399*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4212*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4087*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4150*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5522*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5569*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5460*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5242*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5054*1.016129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=5008*1.016129;


*Female non-farm;

else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1526*1.016129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1464*1.016129;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1907*1.016129;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2081*1.016129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1830*1.016129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2081*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2324*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2215*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2449*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3042*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3151*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3136*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3104*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3650*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3760*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3713*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3588*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4259*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4337*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4274*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4134*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4009*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5350*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5429*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5413*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5226*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5117*1.016129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=4867*1.016129;


*Male farm;

else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1155*1.016129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1037*1.016129;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1444*1.016129;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1618*1.016129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1296*1.016129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1618*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1681*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1736*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1835*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2217*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2250*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2173*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2282*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2675*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2708*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2555*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2610*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=3069*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3079*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2948*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2861*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2905*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3865*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3898*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3822*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3669*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3538*1.016129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3506*1.016129;


*Female farm;

else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1068*1.016129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1025*1.016129;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1335*1.016129;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1457*1.016129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1281*1.016129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1457*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1627*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1551*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1714*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2129*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2206*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2195*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2173*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2555*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2632*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2599*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2512*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=2981*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3036*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2992*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2894*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2806*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3745*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3800*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3789*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3658*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3582*1.016129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3407*1.016129;
end;
*1967 Poverty Thresholds;
*Use 1964 Poverty Thresholds and inflate with CPI-U to 1966
Do not use 1966 Thresholds because some thresholds missing (Family size=2 Age head >65 Number of related children under 18=1);
if &yr=1967 then do;
if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1650*1.04516129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1482*1.04516129;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=2063*1.04516129;
else if  sex_head=0 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2311*1.04516129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1852*1.04516129;
else if  sex_head=0 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2311*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2402*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2480*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2621*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3167*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3214*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3104*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3260*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3822*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3869*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3650*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3728*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4384*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4399*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4212*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4087*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4150*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5522*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5569*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5460*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5242*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5054*1.04516129;
else if  sex_head=0 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=5008*1.04516129;


*Female non-farm;

else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1526*1.04516129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1464*1.04516129;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1907*1.04516129;
else if  sex_head=1 and farm=2 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2081*1.04516129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1830*1.04516129;
else if  sex_head=1 and farm=2 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2081*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=0 then povcut=2324*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=1 then povcut=2215*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=3 and tot_kids=2 then povcut=2449*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=0 then povcut=3042*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=1 then povcut=3151*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=2 then povcut=3136*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=4 and tot_kids=3 then povcut=3104*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=0 then povcut=3650*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=1 then povcut=3760*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=2 then povcut=3744*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=3 then povcut=3713*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=5 and tot_kids=4 then povcut=3588*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=0 then povcut=4259*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=1 then povcut=4337*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=2 then povcut=4306*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=3 then povcut=4274*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=4 then povcut=4134*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final=6 and tot_kids=5 then povcut=4009*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=0 then povcut=5350*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=1 then povcut=5429*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=2 then povcut=5413*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=4 then povcut=5226*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids=5 then povcut=5117*1.04516129;
else if  sex_head=1 and farm=2 and fpersons_final GE 7 and tot_kids GE 6 then povcut=4867*1.04516129;


*Male farm;

else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1155*1.04516129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1037*1.04516129;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1444*1.04516129;
else if  sex_head=0 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1618*1.04516129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1296*1.04516129;
else if  sex_head=0 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1618*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1681*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1736*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1835*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2217*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2250*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2173*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2282*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2675*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2708*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2555*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2610*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=3069*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3079*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2948*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2861*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2905*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3865*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3898*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3822*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3669*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3538*1.04516129;
else if  sex_head=0 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3506*1.04516129;


*Female farm;

else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1068*1.04516129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1025*1.04516129;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1335*1.04516129;
else if  sex_head=1 and farm=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1457*1.04516129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1281*1.04516129;
else if  sex_head=1 and farm=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1457*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=0 then povcut=1627*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=1 then povcut=1551*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=3 and tot_kids=2 then povcut=1714*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=0 then povcut=2129*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=1 then povcut=2206*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=2 then povcut=2195*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=4 and tot_kids=3 then povcut=2173*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=0 then povcut=2555*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=1 then povcut=2632*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=3 then povcut=2599*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=5 and tot_kids=4 then povcut=2512*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=0 then povcut=2981*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=1 then povcut=3036*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=3 then povcut=2992*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=4 then povcut=2894*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final=6 and tot_kids=5 then povcut=2806*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3745*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3800*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3789*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3658*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3582*1.04516129;
else if  sex_head=1 and farm=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3407*1.04516129;
end;


*Create an indicator for whether above or below poverty;
if ftotval_final-povcut GE 0 then poverty=0;
else if ftotval_final-povcut < 0 then poverty=1;
if ftotval_final-fpovcut_final GE 0 then poverty1=0;
else if ftotval_final-fpovcut_final < 0 then poverty1=1;

pov_diff=povcut-fpovcut_final;


run;
*Total population;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
run;

*Just Families Population;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
where famtyp IN(1 2 3);
run;

*Unrelated Individuals Population;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
where famtyp IN(4 5);
run;

*Number of individuals in Poverty in Total Population;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
where poverty=1;
run;

*Number of Individuals from families in Poverty;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
where famtyp IN(1 2 3) and poverty=1;
run;

*Number of Unrelated Individuals in Total Population in Poverty;
proc means sum data=cpsdata.poverty&yr;
var msupwgt;
where famtyp IN(4 5) and poverty=1;
run;

*Poverty Rate Total Population;
proc means data=cpsdata.poverty&yr;
var poverty poverty1 ;
weight msupwgt;
run;

*Poverty Rate Family Population;
proc means data=cpsdata.poverty&yr;
var poverty poverty1 ;
weight msupwgt;
where famtyp IN(1 2 3);
run;

*Poverty Rate Unrelated Individuals Population;
proc means data=cpsdata.poverty&yr;
var poverty poverty1 ;
weight msupwgt;
where famtyp IN(4 5);
run;

%mend poverty6467;
%poverty6467(1964);
%poverty6467(1965);
%poverty6467(1966);
%poverty6467(1967);

*Used these means below to derive statistics in Excel File: Final Population and Poverty Results for CPS 1964-1972.xls;
*Total population;
proc means sum data=cpsdata.poverty1967;
var msupwgt;
run;

*Number of individuals in Poverty in Total Population;
proc means sum data=cpsdata.poverty1967;
var msupwgt;
where poverty=1;
run;
*Number of individuals in Poverty in Total Population - Povcut;
proc means sum data=cpsdata.poverty1967;
var msupwgt;
where poverty1=1;
run;

*Poverty Rate Total Population;
proc means data=cpsdata.poverty1967;
var poverty poverty1 ;
weight msupwgt;
run;
